/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************//*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : 5-BIT SHIFT REGISTER
TRUTHTABLE     : 

        ------------------------------------------------------------
        CLR_   PRE    A  B  C  D  E   CLK  SER   QA  QB  QC  QD  QE
        ------------------------------------------------------------
         L      L     X  X  X  X  X    X    X    L   L   L   L   L

         L      X     L  L  L  L  L    X    X    L   L   L   L   L

         H      H     H  H  H  H  H    X    X    H   H   H   H   H

         H      H     L  L  L  L  L    L    X    QA  QB  QC  QD  QE 

         H      H     H  L  H  L  H    L    X    H   QB  H   QD  H

         H      L     X  X  X  X  X    L    X    QA  QB  QC  QD  QE 
                                        _
         H      L     X  X  X  X  X   _/    H    H   QA  QB  QC  QD  
                                        _
         H      L     X  X  X  X  X   _/    L    L   QA  QB  QC  QD  
        ------------------------------------------------------------ 
  
REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a96 (clk, a, b, c, d, e, pre, ser, qe, qd, qc, qb, qa, clrn);
	parameter size =1;
	parameter cds_action = "ignore";
	input
		clk,
		a,
		b,
		c,
		d,
		e,
		pre,
		ser,
		clrn;
	output
		qe,
		qd,
		qc,
		qb,
		qa;
    reg
        NOTIFY_REG;
    not
	  (pren, pre);
    and
	  (en, clrn, pren);
    nand  
	M96N_inst_NA1 (m96n_inst_pre1, pre, a);
    nand
	M96N_inst_NA2 (m96n_inst_pre2, pre, b);
    nand  
	M96N_inst_NA3 (m96n_inst_pre3, pre, c);
    nand  
	M96N_inst_NA4 (m96n_inst_pre4, pre, d);
    nand  
	M96N_inst_NA5 (m96n_inst_pre5, pre, e);
    buf  
	  (qa, m96n_inst_qaint);
    buf
	  (qb, m96n_inst_qbint);
    buf
	  (qc, m96n_inst_qcint);
    buf
	  (qd, m96n_inst_qdint);
    buf
	  (qe, m96n_inst_qeint);
    U_FD_P_RB_SB_NO
	  (m96n_inst_qaint, ser, clk, clrn, m96n_inst_pre1, NOTIFY_REG);
    U_FD_P_RB_SB_NO  
	  (m96n_inst_qbint, m96n_inst_qaint, clk, clrn, m96n_inst_pre2, NOTIFY_REG);
    U_FD_P_RB_SB_NO  
	  (m96n_inst_qcint, m96n_inst_qbint, clk, clrn, m96n_inst_pre3, NOTIFY_REG);
    U_FD_P_RB_SB_NO  
	  (m96n_inst_qdint, m96n_inst_qcint, clk, clrn, m96n_inst_pre4, NOTIFY_REG);
    U_FD_P_RB_SB_NO  
	  (m96n_inst_qeint, m96n_inst_qdint, clk, clrn, m96n_inst_pre5, NOTIFY_REG);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
